;;  Programm:      ACM-LAYERNAMENAENDERN.LSP
;;  Befehlsaufruf: ACM-LAYERNAMENAENDERN
;;  Funktion:      ndert Umlaute, Eszett- und Leerzeichen sowie die Gro-/Kleinscheibung
;;                 von Layernamen.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         15.05.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-layernamenaendern ( / lna51 lna52 lna65 lna66 anl01 anl02 anl03 anl04 anl05 anl06 anl07 anl08 anl09 anl10 anl11 anl12 anl13 anl14 anl15 anl16 anl17 anl18 anl19 anl20 anl21 anl22 anl23 anl24)
    (defun anl01 (lna01 lna02 / lna14)
        (if (= lna02 "0")
          (setq lna14 (strcase lna01))
        )
        (if (= lna02 "1")
          (setq lna14 (strcase lna01 T))
        )
        (if (= lna02 "2")
          (setq lna14 (strcat (strcase (substr lna01 1 1)) (strcase (substr lna01 2) T)))
        )
      lna14
    )
    (defun anl02 (lna03 lna04 / lna15 lna16 lna17 lna18)
      (setq lna15 (strlen lna03))
      (setq lna16 1)
        (while (<= lna16 lna15)
          (setq lna17 (substr lna03 lna16 1))
            (if (/= lna17 lna04)
              (progn
                (setq lna18 nil)
                (setq lna16 (1+ lna16))
              )
            )
            (if (= lna17 lna04)
              (progn
                (setq lna18 lna16)
                (setq lna16 (1+ lna15))
              )
            )
        )
      lna18
    )
    (defun anl03 (lna05 lna06 / lna19 lna20 lna21 lna22 lna24 lna23)
      (if (= lna06 "")
        (progn
          (alert "Keine Eingabe fr \042Suchen nach\042.")
          (mode_tile "eb_01" 2)
        )
        (progn
          (setq lna19 (mapcar 'strcase lna05))
          (setq lna20 (strcase lna06))
          (setq lna21 "")
          (setq lna22 -1)
          (setq lna23 0)
            (repeat (length lna19)
              (setq lna22 (1+ lna22))
                (if (wcmatch (nth lna22 lna19) lna20)
                  (progn
                    (setq lna21 (strcat lna21 (itoa lna22) " "))
                    (setq lna23 (1+ lna23))
                  )
                )
            )
            (if
              (and
                (<= lna23 250)
                (/= (setq lna24 (vl-string-trim " " lna21)) "")
              )
                (progn
                  (set_tile "lb_01" "")
                  (set_tile "lb_01" lna24)
                  (mode_tile "b_01" 0)
                )
                (progn
                  (set_tile "lb_01" "0")
                  (set_tile "lb_01" "")
                    (if (> lna23 250)
                      (alert "Ungltige Auswahl. Mehr als 250 entsprechende Layer gefunden.")
                      (alert "Es wurden keine entsprechenden Layer gefunden.")
                    )
                  (mode_tile "eb_01" 2)
                  (mode_tile "b_01" 1)
                )
            )
        )
      )
    )
    (defun anl04 (lna03 lna07 / lna15 lna17 lna22 lna25)
      (setq lna15 (strlen lna03))
      (setq lna17 (substr lna03 1 1))
      (setq lna22 0)
        (while
          (and
            (/= (member lna17 lna07) nil)
            (/= lna22 lna15)
          )
            (setq lna03 (substr lna03 2))
            (setq lna17 (substr lna03 1 1))
            (setq lna22 (+ lna22 1))
        )
        (if (/= lna22 lna15)
          (progn
            (setq lna15 (strlen lna03))
            (setq lna25 (substr lna03 lna15 1))
            (setq lna22 lna15)
              (while
                (and
                  (/= (member lna25 lna07) nil)
                  (/= lna22 0)
                )
                  (setq lna03 (substr lna03 1 lna22))
                  (setq lna25 (substr lna03 lna22 1))
                  (setq lna22 (- lna22 1))
              )
          )
        )
      lna03
    )
    (defun anl05 (lna08 lna09 / lna26 lna18 lna27 lna14)
      (if
        (and
          (= (type lna08) 'STR)
          (= (type lna09) 'STR)
        )
          (progn
            (setq lna26 (anl04 lna08 (list lna09)))
            (setq lna18 (anl02 lna26 lna09))
              (if lna18
                (progn
                  (setq lna27 (substr lna26 1 (1- lna18)))
                  (setq lna26 (anl04 (substr lna26 (1+ (strlen lna27))) (list lna09)))
                  (setq lna14 (cons lna27 lna14))
                )
              )
            (setq lna18 (anl02 lna26 lna09))
              (while lna18
                (setq lna27 (substr lna26 1 (1- lna18)))
                (setq lna26 (anl04 (substr lna26 (1+ (strlen lna27))) (list lna09)))
                (setq lna14 (cons lna27 lna14))
                (setq lna18 (anl02 lna26 lna09))
              )
              (if (> (strlen lna26) 0)
                (setq lna14 (cons lna26 lna14))
              )
          )
      )
      (if lna14
        (reverse lna14)
        nil
      )
    )
    (defun anl06 ( / lna28 lna29 lna30)
      (if
        (and
          (setq lna28 (vl-filename-mktemp "acm.dcl"))
          (setq lna29 (open lna28 "w"))
        )
          (progn
            (setq lna30
              (list
                "acm_1b_2023"
                ":dialog{label=\042Anwenden auf Layer\042;"
                ":spacer{height=0.4;}"
                ":list_box{key=\042lb_01\042;width=25;height=9;multiple_select=true;}"
                ":row{"
                ":button{key=\042b_00\042;label=\042&Suchen nach:\042;width=0;fixed_width=true;}"
                ":edit_box{key=\042eb_01\042;width=15;}}"
                ":spacer{height=0.2;}"
                ":row{"
                ":spacer{width=9;}"
                ":column{width=0;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=9;}}}"
              )
            )
              (while lna30
                (write-line (car lna30) lna29)
                (setq lna30 (cdr lna30))
              )
            (setq lna29 (close lna29))
            lna28
          )
          nil
      )
    )
    (defun anl07 (lna10 / lna31 lna32 lna33 lna34 lna14 lna36)
        (if (setq lna31 (anl06))
          (progn
            (setq lna32 (load_dialog lna31))
              (if (not (new_dialog "acm_1b_2023" lna32))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list lna31))
            (start_list "lb_01")
            (mapcar 'add_list lna10)
            (end_list)
              (if (= (get_tile "lb_01") "")
                (mode_tile "b_01" 1)
              )
            (action_tile "lb_01" "(if (> (length (anl05 $value \" \")) 250) (progn (alert \"Ungltige Auswahl. Bitte maximal 250 Eintrge whlen.\") (set_tile $key \"0\") (set_tile $key \"\") (mode_tile \"b_01\" 1)) (progn (if (= $value \"\") (mode_tile \"b_01\" 1) (mode_tile \"b_01\" 0)))))")
            (action_tile "b_00" "(set_tile \"eb_01\" (setq lna33 (vl-string-trim \" \" (get_tile \"eb_01\")))) (anl03 lna10 lna33)")
            (action_tile "eb_01" "(if (= $reason 1) (progn (set_tile $key (setq lna34 (vl-string-trim \" \" $value))) (anl03 lna10 lna34)))")
            (action_tile "b_01" "(setq lna35 (anl05 (setq lna36 (get_tile \"lb_01\")) \" \")) (setq lna35 (mapcar 'atoi lna35)) (while lna35 (setq lna14 (cons (nth (car lna35) lna10) lna14)) (setq lna35 (cdr lna35))) (setq lna14 (reverse lna14)) (done_dialog)")
            (action_tile "b_02" "(setq lna14 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog lna32)
          )
        )
      lna14
    )
    (defun anl08 ( / lna37)
      (setq lna37 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= lna37 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq lna14 T)
            (setq lna14 nil)
        )
        (if (not lna14)
          (alert "\042acm-laengskal\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      lna14
    )
    (defun anl09 (lna11 / )
      (if lna66 (setq *error* lna66))
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun anl10 (lna01 lna02 / lna38 lna39 lna40 lna41 lna42)
        (if (= lna02 0)
          (progn
            (setq lna38 "")
            (setq lna39 "ae")
          )
        )
        (if (= lna02 1)
          (progn
            (setq lna38 "")
            (setq lna39 "Ae")
          )
        )
        (if (= lna02 2)
          (progn
            (setq lna38 "")
            (setq lna39 "oe")
          )
        )
        (if (= lna02 3)
          (progn
            (setq lna38 "")
            (setq lna39 "Oe")
          )
        )
        (if (= lna02 4)
          (progn
            (setq lna38 "")
            (setq lna39 "ue")
          )
        )
        (if (= lna02 5)
          (progn
            (setq lna38 "")
            (setq lna39 "Ue")
          )
        )
        (if (= lna02 6)
          (progn
            (setq lna38 "")
            (setq lna39 "ss")
          )
        )
        (if (= lna02 7)
          (progn
            (setq lna38 " ")
            (setq lna39 "")
          )
        )
        (if (= lna02 8)
          (progn
            (setq lna38 " ")
            (setq lna39 "-")
          )
        )
        (if (= lna02 9)
          (progn
            (setq lna38 " ")
            (setq lna39 "_")
          )
        )
        (if (vl-string-search lna38 lna01)
          (progn
            (while (setq lna40 (vl-string-search lna38 lna01))
                (if (> lna40 0)
                  (progn
                    (setq lna41 (substr lna01 1 lna40))
                    (setq lna42 (substr lna01 (+ lna40 2)))
                  )
                  (progn
                    (setq lna41 "")
                    (setq lna42 (substr lna01 2))
                  )
                )
              (setq lna01 (strcat lna41 lna39 lna42))
            )
          )
        )
      lna01
    )
    (defun anl11 (lna01 / lna43 lna44)
      (setq lna43 lna01)
      (setq lna44 -1)
        (repeat 6
          (setq lna44 (1+ lna44))
          (setq lna01 (anl10 lna01 lna44))
        )
      (list lna43 lna01)
    )
    (defun anl12 (lna01 lna02 / lna43 lna44)
      (setq lna43 lna01)
      (setq lna01 (anl10 lna01 lna02))
      (list lna43 lna01)
    )
    (defun anl13 (lna01 lna02 / lna43 lna44)
      (setq lna43 lna01)
      (setq lna01 (anl10 lna01 lna02))
      (list lna43 lna01)
    )
    (defun anl14 ( / lna28 lna29 lna30)
      (if
        (and
          (setq lna28 (vl-filename-mktemp "acm.dcl"))
          (setq lna29 (open lna28 "w"))
        )
          (progn
            (setq lna30
              (list
                "acm_cln"
                ":dialog{label=\042nderungsoptionen\042;"
                ":spacer{height=0;}"
                ":boxed_column{label=\042Umlaute\042;"
                ":toggle{key=\042tg_01\042;label=\042&Ersetzen\042;}}"
                ":spacer{height=0;}"
                ":boxed_column{label=\042Eszett\042;"
                ":toggle{key=\042tg_02\042;label=\042E&rsetzen\042;}}"
                ":spacer{height=0;}"
                ":boxed_column{label=\042Leerzeichen\042;"
                ":toggle{key=\042tg_03\042;label=\042&Bearbeiten\042;}"
                ":row{"
                ":spacer{width=1;fixed_width=true;}"
                ":column{width=33;fixed_width=true;"
                ":radio_button{key=\042rb_01\042;label=\042E&ntfernen\042;}"
                ":radio_button{key=\042rb_02\042;label=\042Er&setzen durch Bindestrich\042;}"
                ":radio_button{key=\042rb_03\042;label=\042Ersetzen &durch Unterstrich\042;}}}}"
                ":spacer{height=0;}"
                ":boxed_column{label=\042Gro-/Kleinschreibung\042;"
                ":toggle{key=\042tg_04\042;label=\042ndern &in\042;}"
                ":row{"
                ":spacer{width=1;fixed_width=true;}"
                ":column{width=33;fixed_width=true;"
                ":radio_button{key=\042rb_04\042;label=\042&Groschreibung\042;}"
                ":radio_button{key=\042rb_05\042;label=\042&Kleinschreibung\042;}"
                ":radio_button{key=\042rb_06\042;label=\042&1. Zeichen gro\042;}}}}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=3;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=3;}}}"
              )
            )
              (while lna30
                (write-line (car lna30) lna29)
                (setq lna30 (cdr lna30))
              )
            (setq lna29 (close lna29))
            lna28
          )
          nil
      )
    )
    (defun anl15 ( / lna31 lna32 lna46 lna47 lna14)
        (if (/= (type ajztk21_96_htaktjf-ki9a) 'LIST)
          (setq ajztk21_96_htaktjf-ki9a (list "0" "0" "0" "0" "0" "0"))
        )
        (if (setq lna31 (anl14))
          (progn
            (setq lna32 (load_dialog lna31))
              (if (not (new_dialog "acm_cln" lna32))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list lna31))
            (set_tile "tg_01" (nth 0 ajztk21_96_htaktjf-ki9a))
            (set_tile "tg_02" (nth 1 ajztk21_96_htaktjf-ki9a))
            (set_tile "tg_03" (nth 2 ajztk21_96_htaktjf-ki9a))
            (set_tile "tg_04" (nth 3 ajztk21_96_htaktjf-ki9a))
              (if (= (nth 4 ajztk21_96_htaktjf-ki9a) "0")
                (set_tile "rb_01" "1")
              )
              (if (= (nth 4 ajztk21_96_htaktjf-ki9a) "1")
                (set_tile "rb_02" "1")
              )
              (if (= (nth 4 ajztk21_96_htaktjf-ki9a) "2")
                (set_tile "rb_03" "1")
              )
              (if (= (nth 5 ajztk21_96_htaktjf-ki9a) "0")
                (set_tile "rb_04" "1")
              )
              (if (= (nth 5 ajztk21_96_htaktjf-ki9a) "1")
                (set_tile "rb_05" "1")
              )
              (if (= (nth 5 ajztk21_96_htaktjf-ki9a) "2")
                (set_tile "rb_06" "1")
              )
              (if (= (get_tile "tg_03") "0")
                (progn
                  (mode_tile "rb_01" 1)
                  (mode_tile "rb_02" 1)
                  (mode_tile "rb_03" 1)
                )
              )
              (if (= (get_tile "tg_04") "0")
                (progn
                  (mode_tile "rb_04" 1)
                  (mode_tile "rb_05" 1)
                  (mode_tile "rb_06" 1)
                )
              )
              (if
                (and
                  (= (get_tile "tg_01") "0")
                  (= (get_tile "tg_02") "0")
                  (= (get_tile "tg_03") "0")
                  (= (get_tile "tg_04") "0")
                )
                  (mode_tile "b_01" 1)
              )
              (action_tile "tg_01" "(if
                (and
                  (= $value \"0\")
                  (= (get_tile \"tg_02\") \"0\")
                  (= (get_tile \"tg_03\") \"0\")
                  (= (get_tile \"tg_04\") \"0\")
                )
                  (mode_tile \"b_01\" 1)
                  (mode_tile \"b_01\" 0)
                )"
              )
              (action_tile "tg_02" "(if
                (and
                  (= $value \"0\")
                  (= (get_tile \"tg_01\") \"0\")
                  (= (get_tile \"tg_03\") \"0\")
                  (= (get_tile \"tg_04\") \"0\")
                )
                  (mode_tile \"b_01\" 1)
                  (mode_tile \"b_01\" 0)
                )"
              )
              (action_tile "tg_03" "(if
                (and
                  (= $value \"0\")
                  (= (get_tile \"tg_01\") \"0\")
                  (= (get_tile \"tg_02\") \"0\")
                  (= (get_tile \"tg_04\") \"0\")
                )
                  (mode_tile \"b_01\" 1)
                  (mode_tile \"b_01\" 0)
                )
                (if (= $value \"1\")
                  (progn
                    (mode_tile \"rb_01\" 0)
                    (mode_tile \"rb_02\" 0)
                    (mode_tile \"rb_03\" 0)
                  )
                  (progn
                    (mode_tile \"rb_01\" 1)
                    (mode_tile \"rb_02\" 1)
                    (mode_tile \"rb_03\" 1)
                  )
                )"
              )
              (action_tile "tg_04" "(if
                (and
                  (= $value \"0\")
                  (= (get_tile \"tg_01\") \"0\")
                  (= (get_tile \"tg_02\") \"0\")
                  (= (get_tile \"tg_03\") \"0\")
                )
                  (mode_tile \"b_01\" 1)
                  (mode_tile \"b_01\" 0)
                )
                (if (= $value \"1\")
                  (progn
                    (mode_tile \"rb_04\" 0)
                    (mode_tile \"rb_05\" 0)
                    (mode_tile \"rb_06\" 0)
                  )
                   (progn
                    (mode_tile \"rb_04\" 1)
                    (mode_tile \"rb_05\" 1)
                    (mode_tile \"rb_06\" 1)
                  )
                )"
              )
              (action_tile "b_01" "(if (= (get_tile \"rb_01\") \"1\")
                  (setq lna46 \"0\")
                )
                (if (= (get_tile \"rb_02\") \"1\")
                  (setq lna46 \"1\")
                )
                (if (= (get_tile \"rb_03\") \"1\")
                  (setq lna46 \"2\")
                )
                (if (= (get_tile \"rb_04\") \"1\")
                  (setq lna47 \"0\")
                )
                (if (= (get_tile \"rb_05\") \"1\")
                  (setq lna47 \"1\")
                )
                (if (= (get_tile \"rb_06\") \"1\")
                  (setq lna47 \"2\")
                )
                (setq lna14
                  (list
                    (get_tile \"tg_01\")
                    (get_tile \"tg_02\")
                    (get_tile \"tg_03\")
                    (get_tile \"tg_04\")
                    lna46
                    lna47
                  )
                )
                (setq ajztk21_96_htaktjf-ki9a lna14)
                (done_dialog)"
              )
            (action_tile "b_02" "(setq lna14 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog lna32)
          )
        )
      lna14
    )
    (defun anl16 (lna12 / lna48)
      (setq lna48 lna12)
        (if (/= (type ajztk21_96_htaktjf-ki9a) 'LIST)
          (setq ajztk21_96_htaktjf-ki9a (list "0" "0" "0" "0" "0" "0"))
        )
        (if (= (nth 0 ajztk21_96_htaktjf-ki9a) "1")
          (setq lna48 (cadr (anl11 lna48)))
        )
        (if (= (nth 1 ajztk21_96_htaktjf-ki9a) "1")
          (setq lna48 (cadr (anl13 lna48 6)))
        )
        (if (= (nth 2 ajztk21_96_htaktjf-ki9a) "1")
          (setq lna48 (cadr (anl12 lna48 (nth (atoi (nth 4 ajztk21_96_htaktjf-ki9a)) (list 7 8 9)))))
        )
        (if (= (nth 3 ajztk21_96_htaktjf-ki9a) "1")
          (setq lna48 (anl01 lna48 (nth 5 ajztk21_96_htaktjf-ki9a)))
        )
      lna48
    )
    (defun anl17 (lna13 / lna49 lna50)
        (if (tblsearch "LAYER" lna13)
          (progn
            (setq lna49 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
            (setq lna50 (anl16 lna13))
              (if (= (type (vl-catch-all-apply 'vla-put-Name (list (vla-Item lna49 lna13) lna50))) 'VL-CATCH-ALL-APPLY-ERROR)
                (progn
                  (prompt (strcat "\n*Layer \042" lna13 "\042 konnte nicht umbenannt werden.* "))
                  (setq lna51 (1+ lna51))
                )
                (progn
                  (if (/= lna13 lna50)
                    (setq lna52 (1+ lna52))
                  )
                )
              )
          )
        )
      lna50
    )
    (defun anl18 ( / lna49 lna17 lna48 lna53)
      (setq lna49 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for lna17 lna49
          (if
            (and
              (/= (strcase (setq lna48 (vlax-get lna17 'Name))) "0")
              (/= (strcase lna48) "DEFPOINTS")
              (not (vl-string-search "|" lna48))
            )
              (setq lna53 (cons lna48 lna53))
          )
        )
      lna53
    )
    (defun anl19 ( / lna54 lna55 lna56 lna57 lna58 lna59 lna60)
        (if (/= (type ajztk21_96_htaktjf-ki9a) 'LIST)
          (setq ajztk21_96_htaktjf-ki9a (list "0" "0" "0" "0" "0" "0"))
        )
      (setq lna54 (anl18))
      (setq lna55 lna54)
        (while lna55
          (setq lna56 (car lna55))
            (if (= (anl20 lna56) 1)
              (setq lna57 (cons lna56 lna57))
            )
          (setq lna55 (cdr lna55))
        )
      (setq lna55 lna54)
        (while lna55
          (setq lna56 (car lna55))
            (if (= (anl22 lna56) 1)
              (setq lna58 (cons lna56 lna58))
             )
          (setq lna55 (cdr lna55))
        )
      (setq lna55 lna54)
        (while lna55
          (setq lna56 (car lna55))
            (if (= (anl21 lna56) 1)
              (setq lna59 (cons lna56 lna59))
            )
          (setq lna55 (cdr lna55))
        )
        (if (= (nth 3 ajztk21_96_htaktjf-ki9a) "1")
          (setq lna60 lna54)
          (progn
            (if (= (nth 0 ajztk21_96_htaktjf-ki9a) "1")
              (setq lna60 (append lna60 lna57))
            )
            (if (= (nth 1 ajztk21_96_htaktjf-ki9a) "1")
              (setq lna60 (append lna60 lna58))
            )
            (if (= (nth 2 ajztk21_96_htaktjf-ki9a) "1")
              (setq lna60 (append lna60 lna59))
            )
          )
        )
        (if (> (length lna60) 0)
          (acad_strlsort lna60)
          nil
        )
    )
    (defun anl20 (lna01 / )
      (if
        (or
          (vl-string-search "" lna01)
          (vl-string-search "" lna01)
          (vl-string-search "" lna01)
          (vl-string-search "" lna01)
          (vl-string-search "" lna01)
          (vl-string-search "" lna01)
        )
          1
          0
      )
    )
    (defun anl21 (lna01 / )
      (if (vl-string-search " " lna01)
        1
        0
      )
    )
    (defun anl22 (lna01 / )
      (if (vl-string-search "" lna01)
        1
        0
      )
    )
    (defun anl23 ( / lna61 lna62)
      (initget "ausWahlliste Abbrechen")
        (if (not (setq lna61 (getkword "\nnderungsoptionen anwenden auf alle Layer oder [ausWahlliste/Abbrechen] <alle Layer>: ")))
          (setq lna62 0)
          (progn
            (if (= lna61 "ausWahlliste")
              (setq lna62 1)
              (setq lna62 -1)
            )
          )
        )
      lna62
    )
    (defun anl24 ( / lna44 lna63 lna64)
        (if (setq lna44 (anl15))
          (progn
            (if (setq lna63 (anl19))
              (progn
                (setq lna64 (anl23))
                  (if (= lna64 -1)
                    (prompt "\nEs wurden keine nderungen vorgenommen. ")
                  )
                  (if (= lna64 0)
                    (progn
                      (while lna63
                        (anl17 (car lna63))
                        (setq lna63 (cdr lna63))
                      )
                    )
                  )
                  (if (= lna64 1)
                    (progn
                      (if (setq lna63 (anl07 lna63))
                        (progn
                          (while lna63
                            (anl17 (car lna63))
                            (setq lna63 (cdr lna63))
                          )
                        )
                        (prompt "\nEs wurden keine nderungen vorgenommen. ")
                      )
                    )
                  )
              )
              (prompt "\nKeine nderbaren Layer in der Zeichnung vorhanden. ")
            )
          )
          (prompt "\nKeine nderungsoptionen gewhlt. ")
        )
    )
  (if (anl08)
    (progn
      (vl-load-com)
      (setq lna51 0)
      (setq lna52 0)
      (setq lna65 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq lna66 *error*)
      (setq *error* anl09)
      (vla-EndUndoMark lna65)
      (vla-StartUndoMark lna65)
      (anl24)
        (if (> lna51 0)
          (alert (strcat (itoa lna51) " Layer konnte(n) nicht umbenannt werden (siehe Textfenster)."))
        )
      (prompt (strcat "\n*" (itoa lna52) " Layer wurde(n) umbenannt.* "))
        (if lna66
          (setq *error* lna66)
          (setq *error* nil)
        )
      (vla-EndUndoMark lna65)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-LAYERNAMENAENDERN (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-LAYERNAMENAENDERN auf.")
